﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class TooltipController : MonoBehaviour
{
    public static TooltipController instance;

    protected bool isActive = false;
    protected GameObject dialog;
    protected Text text;

    protected string[] dialogTexts;
    protected int dialogCounter;

    private void OnEnable()
    {
        instance = this;
        dialog = transform.GetChild(0).gameObject;
        text = dialog.transform.GetChild(0).GetComponentInChildren<Text>();
    }

    public void Activate(string tooltipText)
    {
        text.text = tooltipText.Replace("\\n", "\n");
        dialog.SetActive(true);
    }

    public void Deactivate()
    {
        isActive = false;
        dialog.SetActive(false);
    }
}
